<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token , Authorization');

$data = file_get_contents('php://input');
if ($data == '')
	return;

$data_array = json_decode($data);

$serverName = "localhost";
$userName = "root";
$userPassword = "";
$dbName = "mydatabase";

$conn = new mysqli($serverName, $userName, $userPassword, $dbName);
$sql = "SELECT * FROM persons";

$stmt = $conn->prepare($sql);
$stmt->execute();
$result = $stmt->store_result();
$recordsTotal = $stmt->num_rows;
$stmt->close();

if ($data_array->search->value != '') {
	$search_value = "%{$data_array->search->value}%";
	$sql .= " WHERE firstName LIKE ? OR lastName LIKE ? LIMIT $data_array->start, $data_array->length";
	$stmt = $conn->prepare($sql);
	$stmt->bind_param('ss', $search_value, $search_value); //   s - string, b - blob, i - int, etc
} else {
	$sql .= " LIMIT $data_array->start, $data_array->length";
	$stmt = $conn->prepare($sql);
}

$stmt->execute();
$result = $stmt->get_result();

$data_return = array(
	'draw' => 0,
	'recordsTotal' => 0,
	'recordsFiltered' => 0,
	'data' => array()
);

if ($result->num_rows === 0) {
	echo json_encode($data_return);
	return;
}

$data_return['draw'] = 0;
$data_return['recordsTotal'] = $recordsTotal;
$data_return['recordsFiltered'] = $recordsTotal;
while ($rs = $result->fetch_assoc()) {
	$data_return['data'][] = array(
		'id' => $rs['id'],
		'firstName' => $rs['firstName'],
		'lastName' => $rs['lastName']
	);
}
echo json_encode($data_return);
$stmt->close();
$conn->close();
