using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using datatables_api_tutorial.Data;
using datatables_api_tutorial.Dtos;
using datatables_api_tutorial.Models;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;

namespace datatables_api_tutorial.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class PersonsController : ControllerBase
    {
        private readonly DataContext _context;

        public PersonsController(DataContext context)
        {
            _context = context;
        }

        [HttpPost("getPersons")]
        public async Task<PagingResponse> getPersons(PagingRequest pagingRequest)
        {
            var pagingResponse = new PagingResponse()
            {
                draw = pagingRequest.draw
            };
            var personQuery = _context.Persons.AsQueryable();
            if (!string.IsNullOrEmpty(pagingRequest.search.value))
            {
                personQuery = personQuery.Where(p =>
                    p.firstName.Contains(pagingRequest.search.value) ||
                    p.lastName.Contains(pagingRequest.search.value)
                );
            }
            var recordsTotal = personQuery.Count();
            pagingResponse.recordsTotal = recordsTotal;
            pagingResponse.recordsFiltered = recordsTotal;
            List<Persons> persons = await personQuery.OrderBy(p => p.id).Skip(pagingRequest.start).Take(pagingRequest.length).ToListAsync();
            pagingResponse.data = persons;
            return pagingResponse;
        }
    }
}